<?php
require_once '../config.php';
verificarLogin();

$titulo = "Clientes";

// Buscar clientes DO USUÁRIO ATUAL
$stmt = $pdo->prepare("
    SELECT c.*, p.nome as plano_nome, p.valor as plano_valor, s.nome as servidor_nome, s.tipo as servidor_tipo
    FROM clientes c 
    JOIN planos p ON c.plano_id = p.id 
    LEFT JOIN servidores s ON c.servidor_id = s.id
    WHERE c.usuario_id = ?
    ORDER BY c.data_vencimento ASC
");
$stmt->execute([$_SESSION['usuario_id']]);
$clientes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --success: #48bb78;
            --warning: #ed8936;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-success { background: var(--success); }
        .btn-warning { background: var(--warning); }
        .btn-danger { background: var(--danger); }
        
        .table-container {
            overflow-x: auto;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        
        th {
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        
        td {
            padding: 15px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        tr:hover {
            background: #f8fafc;
        }
        
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .status-active {
            background: #c6f6d5;
            color: #22543d;
        }
        
        .status-warning {
            background: #fed7d7;
            color: #742a2a;
        }
        
        .status-danger {
            background: #fed7d7;
            color: #742a2a;
        }
        
        .server-badge {
            background: #bee3f8;
            color: #1a365d;
            padding: 4px 8px;
            border-radius: 6px;
            font-size: 0.7rem;
            font-weight: 600;
        }
        
        .whatsapp-btn {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 8px 15px;
            background: #25d366;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        .action-buttons {
            display: flex;
            gap: 5px;
        }
        
        .action-buttons .btn {
            padding: 8px 12px;
            font-size: 0.8rem;
        }
        
        .observacoes {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        
        .observacoes:hover {
            white-space: normal;
            overflow: visible;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #c6f6d5;
            color: #22543d;
            border: 1px solid #9ae6b4;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .page-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            th, td {
                padding: 10px 8px;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="clientes.php" class="active">👨‍💼 Clientes</a></li>
                <li><a href="../planos/planos.php">📋 Planos</a></li>
                <li><a href="../servidores/servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="../senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Gestão de Clientes</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="page-header">
                    <h2>Lista de Clientes</h2>
                    <a href="criar_cliente.php" class="btn">➕ Novo Cliente</a>
                </div>

                <?php if (isset($_GET['sucesso'])): ?>
                    <div class="alert alert-success">
                        <strong>✅ Sucesso!</strong> Cliente criado/editado com sucesso!
                    </div>
                <?php endif; ?>

                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Contato</th>
                                <th>Plano</th>
                                <th>Servidor</th>
                                <th>Validade</th>
                                <th>Observações</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($clientes as $cliente): ?>
                                <?php
                                $data_vencimento = new DateTime($cliente['data_vencimento']);
                                $hoje = new DateTime();
                                $dias_restantes = $hoje->diff($data_vencimento)->days;
                                
                                if ($data_vencimento < $hoje) {
                                    $status_class = 'status-danger';
                                    $status_text = 'Vencido';
                                } elseif ($dias_restantes <= 3) {
                                    $status_class = 'status-warning';
                                    $status_text = 'Próximo';
                                } else {
                                    $status_class = 'status-active';
                                    $status_text = 'Ativo';
                                }
                                ?>
                                <tr>
                                    <td>
                                        <strong><?php echo htmlspecialchars($cliente['nome']); ?></strong>
                                        <div style="font-size: 0.8rem; color: #666;">ID: <?php echo $cliente['id']; ?></div>
                                    </td>
                                    <td>
                                        <a href="https://wa.me/55<?php echo preg_replace('/[^0-9]/', '', $cliente['telefone']); ?>" 
                                           target="_blank" class="whatsapp-btn">
                                            💬 <?php echo htmlspecialchars($cliente['telefone']); ?>
                                        </a>
                                    </td>
                                    <td>
                                        <strong><?php echo htmlspecialchars($cliente['plano_nome']); ?></strong>
                                        <div style="font-size: 0.8rem; color: #666;">
                                            R$ <?php echo number_format($cliente['plano_valor'], 2, ',', '.'); ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($cliente['servidor_nome']): ?>
                                            <span class="server-badge">
                                                🖥️ <?php echo htmlspecialchars($cliente['servidor_nome']); ?>
                                            </span>
                                            <div style="font-size: 0.7rem; color: #666; margin-top: 2px;">
                                                <?php echo htmlspecialchars($cliente['servidor_tipo']); ?>
                                            </div>
                                        <?php else: ?>
                                            <span style="color: #666; font-size: 0.8rem;">Sem servidor</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong><?php echo date('d/m/Y', strtotime($cliente['data_vencimento'])); ?></strong>
                                        <div style="font-size: 0.8rem; color: #666;">
                                            <?php echo $dias_restantes; ?> dias
                                        </div>
                                    </td>
                                    <td>
                                        <div class="observacoes" title="<?php echo htmlspecialchars($cliente['observacoes']); ?>">
                                            <?php echo $cliente['observacoes'] ? htmlspecialchars($cliente['observacoes']) : '---'; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="status-badge <?php echo $status_class; ?>">
                                            <?php echo $status_text; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <a href="editar_cliente.php?id=<?php echo $cliente['id']; ?>" 
                                               class="btn btn-warning">✏️ Editar</a>
                                            <a href="excluir_cliente.php?id=<?php echo $cliente['id']; ?>&csrf_token=<?php echo $security->generateCSRFToken(); ?>" 
                                               class="btn btn-danger"
                                               onclick="return confirm('Tem certeza que deseja excluir este cliente?')">
                                               🗑️ Excluir
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <?php if (empty($clientes)): ?>
                    <div style="text-align: center; padding: 60px 20px; color: #666;">
                        <div style="font-size: 4rem; margin-bottom: 20px;">📭</div>
                        <h3 style="color: var(--secondary); margin-bottom: 10px;">Nenhum cliente encontrado</h3>
                        <p style="margin-bottom: 30px;">Comece adicionando seu primeiro cliente ao sistema.</p>
                        <a href="criar_cliente.php" class="btn">➕ Adicionar Primeiro Cliente</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>